# How to use

## Copy libraries
Copy all the jar files inside the "Notification SDK/Server API/Java/Bin" directory to the "./lib" directory.

## Changes in java class
See in sample/src/main/java/NotificationSDKServerSample and complete all TODOs that are necessary for your device.

### Android
* ANDROID_VASCO_NOTIFICATION_IDENTIFIER
Retrieved from your client sample app after the notification service registration.

* ANDROID_FIREBASE_SERVICE_ACCOUNT_JSON
Place the JSON file anywhere in your project and give a relative path for this variable from the gradle executing the command.
For example, place JSON file in sample/src/main/java/res file and set:
ANDROID_FIREBASE_SERVICE_ACCOUNT_JSON = "src/main/java/res/downloadedJsonFileName.json"
> JSON file can be retrieved from your firebase console
>
> Project -> Project Settings -> Service Account tab -> Click on button "Generate a new key" 
Previously, this server embedded GCM but this will soon be deprecated. We highly recommend to use FCM protocol. 
However, if you still want to use GCM protocol, do not fill this field and GCM protocol will be used on the FCM server.

* Comment following lines:

```
* credentials.setiOSPlatformCredentials(IOS_USE_DEVELOPMENT_SERVER, IOS_P8_FILE_PATH, IOS_KEY_ID, IOS_TEAM_ID); // token-based authentication
* credentials.setiOSPlatformCredentials(IOS_USE_DEVELOPMENT_SERVER, IOS_P12_FILE_PATH, IOS_P12_PASSWORD); // certificate-based authentication
* notification.setiOSBundleId(IOS_BUNDLE_ID);
* notificationServer.sendNotification(IOS_VASCO_NOTIFICATION_IDENTIFIER, notification);
```

### iOS
* IOS_VASCO_NOTIFICATION_IDENTIFIER
* IOS_USE_DEVELOPMENT_SERVER
* IOS_TEAM_ID
* IOS_BUNDLE_ID

* Comment following lines
either
```
* credentials.setiOSPlatformCredentials(IOS_USE_DEVELOPMENT_SERVER, IOS_P8_FILE_PATH, IOS_KEY_ID, IOS_TEAM_ID); // token-based authentication
```
or
```
* credentials.setiOSPlatformCredentials(IOS_USE_DEVELOPMENT_SERVER, IOS_P12_FILE_PATH, IOS_P12_PASSWORD); // certificate-based authentication
```

and:
```
* credentials.setAndroidGoogleServicesJson(ANDROID_GOOGLE_SERVICES_JSON);
* notificationServer.sendNotification(ANDROID_VASCO_NOTIFICATION_IDENTIFIER, notification);
```

#### token-based authentication
* IOS_P12_FILE_PATH
* IOS_P12_PASSWORD

#### certificate-based authentication
* IOS_P8_FILE_PATH
* IOS_KEY_ID

## Launch notification
Open a terminal in sample folder and execute following line:
`./gradlew launchNotification`